/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.setup;

import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.common.item.guns.setup.IMaterialStat;
import dev.toma.gunsrpg.common.item.guns.setup.MaterialContainer;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponBuilder;
import java.util.IdentityHashMap;
import java.util.Map;

public class MaterialContainerBuilder {
    private final WeaponBuilder builder;
    final Map<IAmmoMaterial, IMaterialStat> modifierMap = new IdentityHashMap<IAmmoMaterial, IMaterialStat>();

    public MaterialContainerBuilder(WeaponBuilder builder) {
        this.builder = builder;
    }

    public MaterialContainerBuilder define(IAmmoMaterial material, int value, int levelPredicate) {
        if (this.modifierMap.put(material, IMaterialStat.of(value, levelPredicate)) != null) {
            throw new IllegalStateException("Duplicate material definition: " + material);
        }
        return this;
    }

    public MaterialContainerBuilder define(IAmmoMaterial material, int value) {
        return this.define(material, value, material.defaultLevelRequirement());
    }

    public MaterialContainerBuilder define(IAmmoMaterial material) {
        return this.define(material, 0);
    }

    public WeaponBuilder build() {
        return this.builder.materialContainer(new MaterialContainer(this));
    }
}

